﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin
{
    public partial class Dashboard : System.Web.UI.Page
    {
        protected List<string> Months;
        protected List<string> SalesAmount;
        protected List<string> NoOfOrders;
        protected DataTable topCustomer;
        protected DataTable bestSellerAllTime;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);
            Months = new List<string>();
            SalesAmount = new List<string>();
            NoOfOrders = new List<string>();
            Bindproduct();
            StatisticsChart();
            GetCustomers();
        }

        private void Bindproduct()
        {
            List<Orders> pcList = OrdersBL.GetList(Guid.Empty, Guid.Empty, string.Empty, (Master as Ei8htPOS).ReturnFirstDayOfMonth(0), (Master as Ei8htPOS).ReturnLastDayOfMonth(0));
            if (pcList != null && pcList.Count > 0)
            {
                pcList = pcList.Where(a => a.IsActive).ToList<Orders>();
            }
            stNewSales.Attributes.Add("data-value", pcList.Sum(a => a.PaidAmount).ToString("$0.00"));
            stNewOrders.Attributes.Add("data-value", pcList.Count.ToString());
            stItemsSold.Attributes.Add("data-value", pcList.Sum(a => a.OrdersDetailsList.Count).ToString());
            List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            pbList = (from pb in pbList
                      where pb.UserRoleType.Trim().ToLower() == "user" && pb.IsActive
                      orderby pb.CreatedDate descending
                      select pb).ToList<UserAccount>();
            stUsers.Attributes.Add("data-value", pbList.Count.ToString());

            bestSellerAllTime = ReportsBL.GetTop20Products(DateTime.MinValue, DateTime.MinValue);
            rpTopProducts.DataSource = bestSellerAllTime;
            rpTopProducts.DataBind();

        }

        private void StatisticsChart()
        {
            var StartDate = (Master as Ei8htPOS).ReturnFirstDayOfMonth(6);
            var EndDate = (Master as Ei8htPOS).ReturnLastDayOfMonth(6);
            List<Orders> MonthlyOrder;
            for (int i = 0; i <= 6; i++)
            {
                MonthlyOrder = OrdersBL.GetList(Guid.Empty, Guid.Empty, string.Empty, StartDate, EndDate);
                if (MonthlyOrder != null && MonthlyOrder.Count > 0)
                {
                    MonthlyOrder = MonthlyOrder.Where(a => a.IsActive).ToList<Orders>();
                }
                Months.Add(StartDate.ToString("MMM"));
                SalesAmount.Add(MonthlyOrder.Sum(a => a.PaidAmount).ToString("0.00"));
                NoOfOrders.Add(MonthlyOrder.Count.ToString());
                StartDate = StartDate.AddMonths(1);
                EndDate = EndDate.AddMonths(1);
            }
        }

        private void GetCustomers()
        {
            topCustomer = ReportsBL.GetCustomersByOrderTotal(DateTime.MinValue, DateTime.MinValue);
            while (topCustomer.Rows.Count > 5)
            {
                topCustomer.Rows.RemoveAt(5);
            }
            rpTopCustomers.DataSource = topCustomer;
            rpTopCustomers.DataBind();

            List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            pbList = (from pb in pbList
                      where pb.UserRoleType.Trim().ToLower() == "user" && pb.IsActive
                      orderby pb.CreatedDate descending
                      select pb).ToList<UserAccount>();
            rpEmailIDs.DataSource = pbList;
            rpEmailIDs.DataBind();
        }

        protected void SendEmail(object sender, EventArgs e)
        {
            bool ShowPopup = false;
            if (!string.IsNullOrEmpty(hdnEmailContent.Value))
            {
                List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                if (pbList != null && pbList.Count > 0)
                {
                    pbList = pbList.Where(a => a.IsActive).ToList<UserAccount>();
                }
                string EmailIDs = hdnEmails.Value;
                List<string> Emails;
                if (!string.IsNullOrEmpty(EmailIDs))
                {
                    Emails = EmailIDs.Split('|').ToList();
                    foreach (string Email in Emails)
                    {
                        ShowPopup = true;
                        WebSession.SendQuickReply(pbList.Where(a => a.Email == Email).Select(a => a.FirstName + a.LastName).ToString(), Email, subject.Value, hdnEmailContent.Value);
                    }
                }
                string OtherEmails = txtOthersEmail.Value.Trim();
                if (!string.IsNullOrEmpty(OtherEmails))
                {
                    Emails = new List<string>();
                    Emails = OtherEmails.Split(';').ToList();
                    foreach (string Email in Emails)
                    {
                        ShowPopup = true;
                        WebSession.SendQuickReply(Email, Email, subject.Value, hdnEmailContent.Value);  
                    }

                }
            }
            else
            {
                WebUtilities.ShowMessage(this, "Please compose your email before sending it!");
            }
            if (ShowPopup)
            {
                WebUtilities.ShowMessage(this, "Messages sent successfully!");
            }


        }
    }
}